; JFW Version 3.3
; JFW Script file for Microsoft Word, Office 95 .
; Copyright 1998, 1999  by Henter-Joyce, Inc.
;03/29/99 j.c
; 12/10/98. A.G.

; Spelling and Grammar dialog In Word 97:
; ReadMisSpelledAndSuggestion may be called by the user pressing Insert+F7. 
; It is also called by SaySDMFocusedWindow when the focus changes to the NotInDictionary box 
; and by SayNonHighlightedText when the focus doesn't change but a new misspelled word is written on that control.

include "winword.jsh" ; constants for Word 97
include "winword8.jsm" ; messages for Word 97
include "winword.jsm"
include "hjglobal.jsh"
Include "hjconst.jsh" ; constants for attributes, window classes
include "default.jsm"
use "magWord.jsb"

Globals
	int WordVersion,
	int GlobalCurrentControl,
	HANDLE GlobalRealWindow,
	string GlobalRealWindowName,
	int WinWordFirsttime, ; to say auto start message only first time
	handle WinWordContextHandle, ; read word in context
	Int InEditWindow,
	Int TableFirstTime

Const
	UNKNOWNWORDID = 28, ; unknown/misspelled word control ID in spell check
	REPLACEMENTWORDID = 29 ; replacement word control id in spell check

;*** the following section contains functions used in both Word 95 and 97.

function AutoStartEvent ()
let WordVersion = GetWordVersion ()
  let TableFirstTime = 0
;wwn292="tip of the day"
if (GetWindowName (GetFocus ())== wwn292)
	&& SdmGetFocus (GetFocus ())== 18 then ; on check box
	SdmSayControl (GetFocus (), 17) ; say the tip of the day
	SdmSayControl (GetFocus (), 18) ; say check box
endif ; tip of the day
if (WinWordFirstTime == 0) then
	let WinWordFirstTime = 1
	if GetVerbosity() == beginner then
SayExtendedHelpHotkey()
		Say(wmsg293, ot_help) ;"Use Insert plus the letter H for help in various dialog boxes"
Say(wmsg494, ot_help) ;"for a list of ms word short cut keys use insert + w"
	EndIf ; verbosity beginner
EndIf ; first time
EndFunction

Script ScriptFileName ()
ScriptAndAppNames(msgWordForWindows)
EndScript

Int Function GetWordVersion ()
var int nVersion
let nVersion = GetProgramVersion (GetAppFilePath ())
if (nVersion) then
	return nVersion	
else
	return WORD_6
endif
EndFunction

Script SayWordVersion ()
if (WordVersion == WORD_6) then
	Say("Word 6", ot_message)
else
	PerformScript SayAppVersion()
endif
EndScript

Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	HANDLE RealWindow,
	string RealWindowName,
	HANDLE AppWindow
let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
;wwc294="_sdm_"
if (StringContains (GetWindowClass (RealWindow), wwc294)) then
	; we are in an SDM dialog
	let GlobalRealWindow = RealWindow
	let GlobalRealWindowName = RealWindowName
	let GlobalFocusWindow = FocusWindow
		SaySDMFocusedWindow ()
Else ; not sdm
	;start of regular non-sdm logic
	if (GlobalPrevApp != AppWindow
	&& AppWindow != FocusWindow) then
		; we've switched to a different app main window,
		; and it does not have the focus, so announce it
		SayWindowTypeAndText(AppWindow)
	endif

	If ((GlobalPrevRealName != RealWindowName) ; name has changed
	|| (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
		If ((RealWindow != AppWindow)
		&& (RealWindow != FocusWindow)) then
			SayWindowTypeAndText(RealWindow)
		endif
	EndIf
	; now say the window with focus
	let GlobalFocusWindow = FocusWindow ; to access it from another routine
		SayFocusedWindow()
EndIf ;end else sdm
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes, int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
if (ProcessSelectText(nAttributes,buffer)) then
	return
endif
if (sFrameName == "") then
	; this text is not associated with a frame
	if (nAttributes& ATTRIB_HIGHLIGHT) then
			SayHighlightedText95 (hwnd,buffer)
	else
			SayNonHighlightedText95 (hwnd,buffer)
	endif
else
	; this text is associated with a frame
	if (nEcho == ECHO_NONE) then
		return; frame is being silenced
	endif
	if (nEcho  == ECHO_ALL ||
	   (nAttributes & ATTRIB_HIGHLIGHT)) then
		; if FrameEcho is set to all or the text being written is highlighted
		Say(buffer, ot_buffer)
	endif
endif
EndFunction

Script ReadWordInContext ()
	ReadWordInContext95 ()
Say(wmsg531, ot_message)
EndScript

Script ScreenSensitiveHelp ()
	ScreenSensitiveHelp95 ()
EndScript
Script  HotKeyHelp()
	HotKeyHelp95 ()
EndScript

Int Function WinwordHotKeyHelp ()
var
String strRealName,
String strPage,
int bSuccess
let strRealName = GetWindowName (GetRealWindow (GetFocus ()))
if (strRealName == wnTemplatesAndAddIns) then
	Say(msg288, ot_help) ;"Hot keys are as follows"
	Say(msgDocumentTemplate, ot_help)
	Say(msgAttach, ot_help)
	Say(msgUpdateDocStyles, ot_help)
	Say(msgGlobalTemplates, ot_help)
	Say(msgAdd, ot_help)
	Say(msgOrganizer, ot_help)
	return TRUE
elif (strRealName == wnPageSetup) then
	let strPage = GetDialogPageName ()
	Say(msg288, ot_help) ;"hot keys are as follows"
	if (strPage == fsMargins) then
		Say(msgTop, ot_help)
		Say(msgBottom, ot_help)
		Say(msgLeft, ot_help)
		Say(msgRight, ot_help)
		Say(msgGutter, ot_help)
		Say(msgHeader, ot_help)
		Say(msgFooter, ot_help)
		Say(msgApplyTo, ot_help)
		Say(msgDefault, ot_help)
		Say(msgMirrorMargins, ot_help)
	elif (strPage == fsPaperSize) then
		Say(msgPaperSize, ot_help)
		Say(msgWidth, ot_help)
		Say(msgHeight, ot_help)
		Say(msgPortrait, ot_help)
		Say(msgLandscape, ot_help)
		Say(msgApplyTo, ot_help)
		Say(msgDefault, ot_help)
	elif (strPage == fsPaperSource) then
		Say(msgFirstPage, ot_help)
		Say(msgOtherPages, ot_help)
		Say(msgApplyTo, ot_help)
		Say(msgDefault, ot_help)
	elif (strPage == fsLayout) then
		Say(msgSectionStart, ot_help)
		Say(msgDifferentOddEven, ot_help)
		Say(msgDifferentFirstPage, ot_help)
		Say(msgVerticalAlignment, ot_help)
		Say(msgApplyTo, ot_help)
		Say(msgDefault, ot_help)
		Say(msgLineNumbers, ot_help)
	endif
	return TRUE
elif (strRealName == wnInsertTable) then
	Say(msg288, ot_help) ;"Hot keys are as follows"
	Say(msgNumberOfColumns, ot_help)
	Say(msgNumberOfRows, ot_help)
	Say(msgColumnWidth, ot_help)
	Say(msgWizard, ot_help)
	Say(msgAutoFormat, ot_help)
	return TRUE
elif (strRealName == wnFormula) then
	Say(msg288, ot_help) ;"hot keys are as follows"
	Say(msgFormula, ot_help)
	Say(msgNumberFormat, ot_help)
	Say(msgPasteFunction, ot_help)
	Say(msgPasteBookmark, ot_help)
	return TRUE
elif (strRealName == wnFont) then
	let strPage = GetDialogPageName ()
	Say(msg288, ot_help) ;"Hot keys are as follows"
	if (strPage == fsCharacterSpacing) then
		Say(msgSpacing, ot_help)
		Say(msgSpacingBy, ot_help)
		Say(msgPosition, ot_help)
		Say(msgPositionBy, ot_help)
		Say(msgKerningForFonts, ot_help)
		Say(msgPointsAndAbove, ot_help)
	else
		Say(msgFont2, ot_help)
		Say(msgFontStyle, ot_help)
		Say(msgSize, ot_help)
		Say(msgUnderline, ot_help)
		Say(msgColor, ot_help)
		Say(msgStrikeThrough2, ot_help)
		Say(msgSuperScript2, ot_help)
		Say(msgSubScript2, ot_help)
		Say(msgHidden2, ot_help)
		Say(msgSmallCaps2, ot_help)
		Say(msgAllCaps2, ot_help)
	endif
	Say(msgDefault, ot_help)
	return TRUE
else
	return FALSE
endif
EndFunction

Script SayWindowTitle ()
	SayWindowTitle95 ()
EndScript

Script  SayDefaultButton()
var
	HANDLE WinHandle,
	int SDMControl
; figure out if we're in a dialog box
let WinHandle = GetRealWindow(GetFocus ())
if (GetWindowTypeCode (WinHandle )== WT_DIALOG) then
	if (GetVerbosity () == 0) then
		Say(msg70, ot_message) ;"default button is"
	EndIf
	Say(GetDefaultButtonName (), ot_control_name)
	return
EndIf ; regular dialog
; now check for sdm dialog
;wwc294="_sdm_"
if (StringContains (GetWindowClass (WinHandle), wwc294)) then
	if (GetWindowTypeCode (WinHandle) == WT_BUTTON) then
		if GetVerbosity() == beginner then
			Say(msg70, ot_message) ;"Default button is "
		EndIf
		SdmSayWindowTypeAndText (WinHandle, SdmGetFocus (WinHandle))
		return
		EndIf ; if control with focus is a button
		Say(wmsg470, ot_message) ;"unable to determine the default button In this dialog"
	; work our way through all child windows of the dialog
	return
endif ; sdm dialog active
Say(msg71, ot_message) ;"not in a dialog box"
EndScript

Script ReadBoxInTabOrder ()
var
	HANDLE WinHandle,
	int SDMControl
; figure out if we're in a dialog box
let WinHandle = GetRealWindow(GetCurrentWindow())
if (GetWindowTypeCode (WinHandle )== WT_DIALOG) then
	if GetVerbosity() == 0 then
		Say(msg34, ot_message) ;"Reed Box in tab order "
	EndIf
	Say(GetWindowName (WinHandle), ot_window_name)
; work our way through all child windows of the dialog
	let WinHandle   = GetFirstChild (WinHandle)
	while (WinHandle)
		SayControl (WinHandle)
		let WinHandle = GetNextWindow (WinHandle)
	EndWhile
	return
endif ; regular dialog active
; now check for sdm dialog
let WinHandle = GetRealWindow(GetCurrentWindow())
;wwc294="_sdm_"
if (StringContains (GetWindowClass (WinHandle), wwc294)) then
; this is an sdm dialog
	if GetVerbosity() == beginner then
		Say(msg34, ot_message) ;"Reed Box in tab order "
	EndIf
	Say(GetWindowName (WinHandle), ot_window_name)
	; work our way through all child windows of the dialog
	SaveCursor ()
	InvisibleCursor ()
	let SDMControl   = SDMGetFirstControl (WinHandle)
	while (SDMControl)
		MoveToControl (WinHandle, SDMControl)
		SayObjectTypeAndText ()
		let SDMControl = SDMGetNextControl (WinHandle, SDMControl)
	EndWhile
	RestoreCursor ()
	return
EndIf ; sdm dialog active
Say(msg35, ot_message) ;"Not a dialog box"
EndScript

Script FontDialog ()
	Say(msgFont, ot_font)
{Control+Shift+F}
EndScript

Script PointSize ()
	Say(msgPointSize, ot_font)
{Control+Shift+P} ; Word command
EndScript

Script LeftJustify ()
{control + l}
Pause ()
Say(wmsg417, ot_message) ;"Left aligned"
EndScript

Script  CenterText()
{control + e}
Pause ()
Say(wmsg418, ot_message) ;"centered"
EndScript

Script  RightJustify()
{control + r}
Pause ()
Say(wmsg419, ot_message) ;"right aligned"
EndScript

Script  JustifyText()
{control + j}
Pause ()
Say(wmsg420, ot_message) ;"Justified"
EndScript

Script SayLineAndColumn ()
	SayLineAndColumn95 ()
EndScript

Script  DeleteWord()
; delete current word and speak the word the PC cursor lands on.
{Control+Delete}
PCCursor ()
delay (1) ; causes a one tenth if a second delay to land on the word we want.
SayWord ()
EndScript

Script PreviousPage ()
	TopOfScreen95 ()
EndScript

Script NextPage ()
	BottomOfScreen95 ()
EndScript

Script  SayField()
SayField()
EndScript

Script ToggleWritingMode ()
	ToggleWritingMode95 ()
EndScript

Script SayFont ()
	SayFont95 ()
EndScript

Script BoldText ()
	BoldText95 ()
EndScript

Script ItalicText ()
	ItalicText95 ()
EndScript

Script UnderlineText ()
	UnderlineText95 ()
EndScript


Script WindowKeysHelp ()

var
	handle WinHandle,
	int Verbosity
let WinHandle = GetFocus ()
let Verbosity = GetVerbosity ()
if (GetWindowName (WinHandle) == wn_SpellingAndGrammar) then
	Say(msgIncorrectWordAndSuggestion +
		GetScriptKeyName ("ReadMistakeAndSuggestion"), ot_help)
	Say(msgReadWordInContext +
		GetScriptKeyName ("ReadWordInContext"), ot_help)
If (Verbosity == Beginner) then
	Say(msgAppHotKeys, ot_help)
	return
EndIf
EndIf
Say(wmsg495, ot_help) ;"the following Ms Word short cut keys may be useful"
Say(wmsg496, ot_help) ;"to create a new document use control + N"
Say(wmsg497, ot_help) ;"to open an existing document use control + O"
Say(wmsg498, ot_help) ;"to save a document use control + S"
Say(wmsg499, ot_help) ;"to print a document use control + P"
Say(wmsg500, ot_help);"to undo the last edit command use control + Z"
Say(wmsg501, ot_help) ;"to repeat the last edit command use control + Y"
Say(wmsg502, ot_help) ;"to cut the selected text to the clip board use control + X"
Say(wmsg503, ot_help) ;"to copy the selected text to the clip board use control + C"
Say(wmsg504, ot_help) ;"to paste text from the clip board into a document use control + V"
Say(wmsg505, ot_help) ;"to select the entire document use control + A"
Say(wmsg506, ot_help) ;"to search for specific words or phrases use control + F"
Say(wmsg507, ot_help) ;"to find and replace specific words or phrases use control + H"
Say(wmsg508, ot_help) ;"to go to a specific line paragraph or page use control + G"
Say(wmsg509, ot_help) ;"to center text with in a document use control + E"
Say(wmsg510, ot_help) ;"to left justify text with in a document use control + L"
Say(wmsg511, ot_help) ;"to right justify text with in a document use control + R"
Say(wmsg512, ot_help) ;"to justify text with in a document use control + J"
Say(wmsg513, ot_help) ;"to change the point size of the font use control + shift + P"
Say(wmsg514, ot_help) ;"to change the font type use control + shift + F"
Say(wmsg515, ot_help) ;"to delete the current word use control + delete"
say(wmsg516, ot_help) ;"to delete the previous word use control + back space"
Say(wmsg517, ot_help) ;"to bold text with in a document use control + B"
Say(wmsg518, ot_help) ;"to italicize text with in a document use control + I"
Say(wmsg519, ot_help) ;"to underline text with in a document use control + U"
Say(wmsg520, ot_help) ;"to insert a hyper link with in a document use control + K"
Say(wmsg521, ot_help) ;"to check spelling or grammar with in a document use F7"
Say(wmsg522, ot_help) ;"to name and save a document use F12"
EndScript

Function SayFocusedWindow ()
;wwc296="OpusWwd"
if (GetWindowClass (GlobalFocusWindow) == wwc296) then
	Say(wmsg297, ot_control_name) ;"edit"
	let WinWordContextHandle = GlobalFocusWindow ; read word in context
	PCCursor ()
	return
endif ; class = OpusWwd
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Void Function SaySDMFocusedWindow ()
let GlobalCurrentControl = SdmGetFocus (GlobalFocusWindow)
;wwn295="Spelling:"
if ((GlobalRealWindowName == wwn295)
&& (GlobalCurrentControl == 29)) then
	; highlighted text event says the mispelled word
	return
endif ; spell dialog box on "word not found"
; If we've just entered a new real window say it
If (GlobalPrevReal != GlobalRealWindow)
|| GlobalRealWindowName != GlobalPrevRealName then
	SayWindowTypeAndText (GlobalRealWindow) ; dialog box name
	;SdmSayWindowTypeAndText (GlobalRealWindow, SdmGetFocus (GlobalRealWindow ))
	SdmSayStaticText (GlobalRealWindow) ;dialog box text
endif ; new real window handle or name
; now say the current control
If (GlobalCurrentControl > 0) then
	SdmSayWindowTypeAndText (GlobalFocusWindow, GlobalCurrentControl)
EndIf ; control id > 0
EndFunction

Void Function SayHighlightedText95 (handle hwnd, string buffer)
if(GetScreenEcho() > 0) Then
;wwn295="Spelling:"
if ((GlobalRealWindowName == wwn295)
&& (GlobalCurrentControl == 29)) then
return
endif ; spell dialog box on "word not found"
Say(buffer, ot_buffer) 
EndIf
EndFunction

Void Function SayNonHighlightedText95 (handle hwnd, string buffer)
var
	string TheClass
let TheClass = GetWindowClass(hwnd)
if ((GetScreenEcho() > 1) ||
;wwn309=DialogClass
(TheClass == wwn309 )) then
	Say(buffer, ot_buffer)
	Return
EndIf
if (GlobalCurrentControl == 29) then
;wwn295=SpellingPrompt
	if (GlobalRealWindowName == wwn295) then
	;wwn310="Not in Dictionary"
		if ((StringContains (buffer, wwn310))
		;wwn311="Capitalization:"
		|| (StringContains (buffer, wwn311))
		;wwn312="Repeated Word:"
		|| (StringContains (buffer, wwn312))) then
			delay (2)
			ReadMistakeAndSuggestion ()
		EndIf
	EndIf
EndIf
EndFunction

Void Function SayFont95 ()
var
	handle WinHandle
let WinHandle = GetFocus ()
if not (IsPCCursor ()) then
	PerformScript SayFont ()
	return ; all done, jaws or invisible cursor is on
EndIf ;is not pc cursor
; now read the tool bar to determine centered, bold, font, point size, etc.
SaveCursor ()
InvisibleCursor ()
;wfg317="bold button pressed"
If (FindGraphic (WinHandle, wfg317, s_top, s_unrestricted)) then
	Say(wmsg318, ot_font) ;"bolded"
EndIf
;wfg319="italics button pressed"
If (FindGraphic (WinHandle, wfg319, s_top, s_unrestricted)) then
	Say(wmsg320, ot_font) ;"italicized"
EndIf
;wfg321="underline button pressed"
If (FindGraphic (WinHandle, wfg321, s_top, s_unrestricted)) then
	Say(wmsg322, ot_font) ;"underlined"
EndIf
;wfg323="Align Left Button Pressed"
If (FindGraphic (WinHandle, wfg323, s_top, s_unrestricted)) then
	Say(wmsg324, ot_font) ;"Aligned left"
EndIf
;wfg325="Align center button pressed"
If (FindGraphic (WinHandle, wfg325, s_top, s_unrestricted)) then
	Say(wmsg326, ot_font) ;"Centered"
EndIf
;wfg327="Align Right Button Pressed"
If (FindGraphic (WinHandle, wfg327, s_top, s_unrestricted)) then
	Say(wmsg328, ot_font) ;"aligned right"
EndIf
;wfg329="Align Justified Button Pressed"
If (FindGraphic (WinHandle, wfg329, s_top, s_unrestricted)) then
	Say(wmsg330, ot_font) ;"justified"
EndIf
RestoreCursor ()
performScript SayFont ()
If (GetVerbosity ()==0) then
	;wwn336=" use Control Shift P to see the print point size"
	Say(wwn335 + wwn336, ot_font)
	Say(wmsg338, ot_font) ;"Tab between the controls to obtain the desired information"
Endif
EndFunction

Void Function ReportFont95 (string strButton, string strButtonPressed)
Pause()
SaveCursor ()
InvisibleCursor ()
If (FindGraphic (GetFocus (), strButtonPressed, s_top, s_unrestricted)) then
	Say(strButtonPressed, ot_status)
	return
EndIf
if (FindGraphic (GetFocus (), strButton, s_top, s_unrestricted)) then
	Say(strButton, ot_status)
	return
EndIf
Say(strButton + wmsg471, ot_status); " not found"
EndFunction

Void Function BoldText95 ()
{control+b}
;wn421 = "Bold Button"
;wfg317 = "Bold Button Pressed"
ReportFont95(wwn421, wfg317)
EndFunction

Void Function ItalicText95 ()
;wwn423 = "italics button"
;wfg319 = "italics button pressed"
{control+i}
ReportFont95 (wwn423, wfg319)
EndFunction

Void Function UnderlineText95 ()
;wwn425 = "underline button",
;wfg321 = "underline button pressed"
{control+u}
ReportFont95 (wwn425, wfg321)
EndFunction

Void Function SayLineAndColumn95 ()
{shift+control+delete}
pause ()
InvisibleCursor ()
;wfs392="Column:"
If ((FindString (GetFocus (), wfs392, S_BOTTOM, S_UNRESTRICTED))
;wwc393="OpusStat"
&& (GetWindowClass (GetCurrentWindow ()) == wwc393)) then
	if GetVerbosity() == 0 then
		Say(wmsg394, ot_position)		 ;"Table Cursor Position"
	EndIf
	Say(GetLine (), ot_text)
Else
	if GetVerbosity() == 0 then
	Say(wmsg395, ot_position) ;"PC cursor position"
	EndIf
	SaveCursor ()
	RouteInvisibleToPc ()
	InvisibleCursor ()
	JAWSPageDown ()
	JAWSHome ()
	NextWord ()
	NextWord ()
	NextWord ()
	NextWord ()
	NextWord ()
	NextWord ()
	NextWord () ; now on "ln"
	SayWord ()
	NextWord ()
	SayWord ()
	NextWord ()
	SayWord ()
	NextWord ()
	SayWord ()
	RestoreCursor ()
EndIf
PcCursor ()
EndFunction

Void Function SayWindowTitle95 ()
var
HANDLE CurrentWindow,
HANDLE RealWindow,
HANDLE AppWindow
let CurrentWindow = GetCurrentWindow()
if (CurrentWindow > 0) then ; handle not 0
let RealWindow = GetRealWindow (CurrentWindow)
let AppWindow = GetAppMainWindow (CurrentWindow)

	if GetVerbosity() == 0 then
		Say(msg30, ot_message) ;"Title ="
	EndIf

;wwn377="options"
	If ((GetWindowName (RealWindow) == wwn377) 
;wwn107="page setup"
		|| (GetWindowName (RealWindow) == wwn107)
;wwn378="index and tables"
		|| (GetWindowName (RealWindow) == wwn378)
;wfs268="font"
		|| (GetWindowName (RealWindow) == wfs268) 
;wwn379="paragraph"
		|| (GetWindowName (RealWindow) == wwn379)
;wwn380="paragraph borders and shading"
		|| (GetWindowName (RealWindow) == wwn380)	
;wwn381="Bullets and numbering"
		|| (GetWindowName (RealWindow) == wwn381)
;wwn382="Drawing defaults"
		|| (GetWindowName (RealWindow) == wwn382)
;wwn383="envelopes and labels"
		|| (GetWindowName (RealWindow) == wwn383)
;wwn210="customize"
		|| (GetWindowName (RealWindow) == wwn210)
;wwn384="cell height and width"
		|| (GetWindowName (RealWindow) == wwn384)) then
			Say(GetWindowName (RealWindow), ot_window_name) 
			if (IsMultiPageDialog ()) then
				Say(msg31, ot_message) ;"page is"
				Say(GetDialogPageName (), ot_dialog_name)
				return
			else
				if ( FindFirstAttribute (ATTRIB_BOLD)) then
					if (FindNextAttribute (ATTRIB_BOLD)) then
						if (GetVerbosity () == 0) then
							Say(msg31, ot_message) ;"page is"
						endif
						SayChunk ()
					else
						Say(wmsg398, ot_message) ;"page not found"
					endif
				endif
				PCCursor ()
				return
			endif
	endif ; end if options dialog
if AppWindow != CurrentWindow then
Say(GetWindowName (AppWindow), ot_window_name)
endif
If ((RealWindow != AppWindow)
&& (RealWindow != CurrentWindow)) then
Say(GetWindowName (RealWindow), ot_window_name)
endif
;now say the current window
Say(GetWindowName (CurrentWindow), ot_window_name)
else
PerformScript SaySpecialWindowClasses(); when handle =0
endif
EndFunction

Void Function MoveToNextParagraph95 ()
if IsPCCursor () then
;wwc296="Opus	Wwd"
if GetWindowClass (GetFocus ()) == wwc296 then ; main document window
{Control+Down Arrow} ; perform the original key function
delay (1)
SayLine ()
return
endif ; main document window
endif ; pc cursor on
; now figure out if sdm or standard dialog 
;wwc402="sdm"
if StringContains (GetWindowClass (GetCurrentWindow ()), wwc402) then
SdmSayControl (GetCurrentWindow (), GetCurrentControlID ())
return
endif ; sdm window
; now handle the standard jfw control down arrow function
PerformScript ControlDownArrow ()
EndFunction

Function TopOfScreen95 ()
{Control+Page Up} ; do the original function
Say(wmsg399, ot_message) ;"Top of screen"
PCCursor ()
delay (1)
SayLine ()
EndFunction

Function BottomOfScreen95 ()
{Control+Page Down} ; do the original function
Say(wmsg400, ot_message) ;"Bottom of screen"
PCCursor ()
delay (1)
SayLine ()
EndFunction

Script ReadMistakeAndSuggestion ()
;wwn295="Spelling:"
If (GetWindowName (GetRealWindow (GetFocus ())) == wwn295) Then
    if (ToggleRestriction ()) then
        ToggleRestriction () ; turn it off
    endif ; if restriction on
    RouteInvisibleToPc()
    InvisibleCursor()
MoveToControl (GetRealWindow (GetFocus ()), UNKNOWNWORDID) 
    If (GetVerbosity () > beginner) then
        SayWord ()
    Else
        SayLine ()
    EndIf
	SpellString (GetChunk())
	;wfs433 = "Repeated Word:" 
	if (FindString (GetFocus(),wfs433, S_TOP, S_UNRESTRICTED)) then
		return
	endif
	
    ; now see if there are any suggestions
    ;wfs306="(no suggestions)"
    if (FindString (GetFocus (), wfs306, s_top, s_unrestricted))
    && GetCurrentControlID () == 30 then ; actualy on the suggestions box message
        ;SayChunk () ; includes the ( & ), not desired
        Say(wmsg307, ot_message) ;"no suggestions"
    else ; there are suggestions, read the first one
MoveToControl (GetRealWindow (GetFocus ()), REPLACEMENTWORDID)
        If (GetVerbosity () > beginner) then
            SayWord ()
        Else
            SayLine()
        EndIf ; verbosity beginner
	SpellString (GetChunk())
    endif ; finst string "no suggestions"
    PcCursor()
Else
    Say(wmsg308, ot_message) ;"Not in spell checker"
EndIf
EndScript

Void Function ReadWordInContext95 ()
if (WinWordContextHandle != 0) then ; valid window handle
JawsCursor ()
MoveToWindow (WinWordContextHandle)
if (FindFirstAttribute (attrib_highlight)) then
if GetVerbosity() == 0 then
Say(wmsg404, ot_message) ;"Reed word in context"
EndIf
SayLine ()
Else
Say(wmsg405, ot_message) ;"highlighted word not found"
endif
else
Say(wmsg406, ot_message) ;"invalid window handle"
Say(wmsg407, ot_message) ;"open a dialog box and then exit to reset window handle"
endif
EndFunction

Void Function ScreenSensitiveHelp95 ()
var
	String TheClass,
	handle Winhandle
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
Let WinHandle = GetRealWindow (GetFocus ())
Let TheClass = GetWindowClass (GetCurrentWindow ())
If (StringContains (GetWindowName (GetRealWindow (GetCurrentWindow())), wwn295)) then
	if (GetCurrentControlID () == 28) then
		Say(wmsg435+wmsg436, ot_help) ;"this list box contains the highlighted word in the document" + "that is in question"
		return
	endif
	if (GetCurrentControlID () == 29) then
		;fs306 = "(no suggestions)"
		SaveCursor()
		InvisibleCursor()
		MoveToControl (Winhandle, 29)
		if (GetCharacter() == " ") then
			Say(wmsg438b, ot_help); "type a new word and press alt c or"
			Say(wmsg438c, ot_help); "press alt d to delete the word in question from the document or"
			Say(wmsg438d, ot_help); "press alt i to ignore")
		else
			Say(wmsg439b, ot_help); "This field contains a suggested change"
			Say(wmsg439c, ot_help); "Press alt c to accept the change or"
			Say(wmsg439d, ot_help); "type a new word and press alt c or"
			Say(wmsg439e, ot_help); "or press alt i to ignore"
		endif	
		return
	endif
	if (GetCurrentControlID () == 30) then
		SaveCursor()
		InvisibleCursor()
		MoveToControl (Winhandle,30)		
		if (GetChunk() == wfs306) then
			Say(wmsg439f, ot_help); "This is the suggestions list box"
			Say(wmsg439g, ot_help) ;"there are currently no suggestions"
		else
			Say(wmsg440, ot_help) ;"this list box contains a list of suggestions"
			Say(wmsg441, ot_help) ;"use the arrow keys to select the desired item"
			Say(wmsg442, ot_help) ;"press alt c to make the correction"
		endif
	return
	endif
	if (GetCurrentControlID () == 31) then
		Say(wmsg443, ot_help) ;"this combo box contains the name of the dictionary file"
		Say(wmsg444, ot_help) ;"When you add words to the dictionary they are added to this file"
		Say(wmsg445, ot_help) ;"use the down arrow key to open the listbox"
		return
	endif
	if (GetCurrentControlID () == 16) then
		Say(wmsg446, ot_help) ;"ignore a single occurrence of the current selection"
		Say(wmsg447, ot_help) ;"use alt i to activate this button"
		return
	endif
	if (GetCurrentControlID () == 17) then
		Say(wmsg448, ot_help) ;"ignore all occurrences of the current selection"
		Say(wmsg448b, ot_help) ;"use alt g to activate this button"
		return
	endif
	if (GetCurrentControlID () == 18) then
		SaveCursor ()
		RouteInvisibleToPc ()
		;wfs448c = "Delete"
		if (GetWord() == wfs448c) then
			RestoreCursor()
			Say(wmsg448d, ot_help) ; "Delete the highlighted word from the document"
			Say(wmsg448e, ot_help) ; "use alt d to activate this button"
		else
			RestoreCursor()
			Say(wmsg449+ wmsg450, ot_help) ;" of the change to edit field"
			Say(wmsg451, ot_help) ;"this button will change the current selection only"
			Say(wmsg451b, ot_help) ;"use alt c to activate this button"
		endif
		return
	endif
	if (GetCurrentControlID () == 19) then
		if (GetWord() == msgDelete) then
			Say(msgDelete, ot_help) ; "Delete the word in question from your document"
			Say(msgbutton, ot_help) ; "Use alt D to activate this button"
		else
			Say(wmsg449+ wmsg450, ot_help) ;" of the change to edit field"
			Say(wmsg452, ot_help) ;"this button will change all occurrences of this selection"
			Say(wmsg452b, ot_help) ;"use alt l to activate this button"
		endif
		return
	endif
	if (GetCurrentControlID () == 20) then
		Say(wmsg453, ot_help) ;"add the current selection to the dictionary file"
		Say(wmsg454, ot_help) ;"the dictionary file is set in the Add words to combo box"
		Say(wmsg454b, ot_help) ;"use alt eigh to activate this button"
		return
	endif
	if (GetCurrentControlID () == 21) then
		Say(wmsg455, ot_help) ;"fill the suggestions list box"
		Say(wmsg455b, ot_help) ;"use enter or the space bar to press this button"
		return
	endif
	if (GetCurrentControlID () == 22) then
		Say(wmsg456, ot_help) ;"add the current selection to the auto correct file"
		Say(wmsg457, ot_help) ;"words in this file are corrected automatically as you type"
		Say(wmsg457b, ot_help) ;"use alt r to activate this button"
		return
	endif
	if (GetCurrentControlID () == 23) then
		Say(wmsg457c, ot_help) ;"open the options dialog"
		Say(wmsg457d, ot_help) ;"this dialog specifies the rules that word uses to check spelling"
		Say(wmsg457e, ot_help) ;"press alt o to activate this button"
		return
	endif
	if (GetCurrentControlID () == 24) then
		Say(wmsg458, ot_help) ;"reverse the most recent actions made during a spell check session"
		Say(wmsg460, ot_help) ;"you can select this button repeatedly to undo past changes"
		Say(wmsg461b, ot_help) ;"use alt u to activate this button"
		return
	endif
	if (GetCurrentControlID () == 25) then
		Say(wmsg462, ot_help) ;"cancel this spell check session"
		Say(wmsg463, ot_help) ;"use enter or spacebar to activate this button"
		return
	endif
endif
;wwc296="OpusWwd"
if TheClass == wwc296 then ; main document window
	Say(msgMainDocWindow, ot_help) ;"this is the main document window"
	return
endif ; OpusWwd
;wwc294="_sdm_"
if StringContains (TheClass, wwc294) then
	Say(wmsg414, ot_help) ;"this is a Word sdm dialog, "
	ScreenSensitiveHelpForUnknownClasses ()
	return
endif ; sdm
PerformScript ScreenSensitiveHelp ()
EndFunction

Void Function HotKeyHelp95 ()
var
handle RealWindow,
string TheClass,
int RepeatedWord,
String WindowName,
int nSuccess

let RealWindow = GetRealWindow (GetFocus ())
let TheClass = GetWindowClass (GetFocus())
let RepeatedWord = 0
let WindowName= GetWindowName (GetRealWindow (GetFocus ()))
; The following section is the intersection between word7 and word6
;wwn295="Spelling:"
if (GetWindowName (GetRealWindow (GetFocus())) == wwn295) then
	;wfs433 = "Repeated Word:"
	if (FindString (GetFocus(),wfs433 , S_TOP, S_UNRESTRICTED)) then
		Say(wmsg343, ot_help) ;"To hear the word in question use Insert plus F7"
		Say(wmsg344, ot_help) ; "To hear the word in context use insert c"
		Say(wmsg345, ot_help) ; "Use the tab key or the following windows hot keys"
		Say(wmsg348, ot_help) ; "To Choose the ignore option use Alt I"
		Say(wmsg348b, ot_help) ;"to choose the delete option use alt d"
		Say(wmsg355, ot_help) ; "To undo last change use Alt U"
		Say(wmsg356, ot_help) ; "To go to Options dialog box use Alt O"
	else
		Say(wmsg343b, ot_help) ;"To hear the misspelled word and suggestion use Insert plus F7"
		Say(wmsg344, ot_help) ;"To hear the word in context use insert c"
		Say(wmsg345, ot_help) ;"Use the tab key or the following windows hot keys"
		Say(wmsg350, ot_help) ;"To except the reccommended change use Alt C"
		Say(wmsg351, ot_help) ;"To except the reccommended change for all occurrances use Alt L"
		Say(wmsg348, ot_help) ;"To Choose the ignore option use Alt I"
		Say(wmsg349, ot_help) ;"To choose the ignore all option use Alt G"
		Say(wmsg346, ot_help) ;"To move to suggestions list box use Alt N"
		Say(wmsg347, ot_help) ;"To return to Change to: edit box use Alt T"
		Say(wmsg352, ot_help) ;"To choose the Auto Correct option use Alt R"
		Say(wmsg353, ot_help) ;"To select a specific dictionary to add words use Alt W"
		Say(wmsg354, ot_help) ;"To Add word to dictionary use Alt A"
		Say(wmsg355, ot_help) ;"To undo last change use Alt U"
		Say(wmsg356, ot_help) ;"To go to Options dialog box use Alt O"
		Say(wmsg357, ot_help) ;"For Help with spell checker use Alt H or escape to cancel"
	endif
	Return
EndIf
if (GetWindowClass (GetRealWindow (GetFocus ()))=="Bosa_SDM_Microsoft Word For Windows") then
	Say(wmsg537 + GetWindowName(GetRealWindow(GetFocus())) + " dialog box", ot_help)
	Say(wmsg538, ot_help)
	Say(wmsg539, ot_help)
	;take care of some known problematic dialogs.  If it is not problematic, then
	;use the HotKeyHelpDefaultLoop
	if (!WinwordHotKeyHelp()) then HotKeyHelpDefaultLoop () endif
	return
else
	GeneralJAWSHotKeys ()
endif

; added above 10/24/95, th, should change all "GetWindowName (GetFocus ())" to "RealWindow"
; this section is for word6 only
;wwn313="Save As"
if (GetWindowName (GetRealWindow (GetFocus())) == wwn313) then
Say(wmsg358, ot_help) ;"type in a path and file name then enter"
Say(wmsg359, ot_help) ;"You can Tab through the various controls or use the following Windows hot keys"
Say(wmsg360, ot_help) ;"For the disk drives list, use Alt V then type the drive letter"
Say(wmsg361, ot_help) ;"To select the path use Alt D for the directories list box"
Say(wmsg362, ot_help) ;"For type of files list use Alt T, and arrow thru the list."
Say(wmsg363, ot_help) ;"To return to File Name edit box use Alt N and then you can type in a name"
Say(wmsg364, ot_help) ;"To go to the Options dialog box use Alt O"
Say(wmsg365, ot_help) ;"For Help with Save As use Alt H or escape to cancel"
Return
EndIf
;wwn152="Print"
if (GetWindowName (GetRealWindow (GetFocus())) == wwn152) then
Say(wmsg366, ot_help) ;"Tab through the controls to make selections or use the following Windows keys"
Say(wmsg367, ot_help) ;"To print all pages use Alt Ai"
Say(wmsg368, ot_help) ;"For current page use Alt E"
Say(wmsg369, ot_help) ;"To choose the document to print use Alt P"
Say(wmsg370, ot_help) ;"To select certain pages or ranges use Alt G"
Say(wmsg371, ot_help) ;"To choose number of copies printed use Alt C"
Say(wmsg372, ot_help) ;"To select specific printer use Alt T"
Say(wmsg373, ot_help) ;"Print to file use Alt L"
Say(wmsg374, ot_help) ;"To change collate copies check box use Alt I"
Say(wmsg375, ot_help) ;"For Options dialog box use Alt O"
Say(wmsg376, ot_help) ;"Alt H for Help with options or escape to cancel"
Return
EndIf
;wwn377="options"
If ((GetWindowName (RealWindow) == wwn377)
;wwn107="page setup"
|| (GetWindowName (RealWindow) == wwn107)
;wwn378="index and tables"
|| (GetWindowName (RealWindow) == wwn378)
;wfs268="font"
|| (GetWindowName (RealWindow) == wfs268)
;wwn379="paragraph"
|| (GetWindowName (RealWindow) == wwn379)
;wwn380="paragraph borders and shading"
|| (GetWindowName (RealWindow) == wwn380)
;wwn381="Bullets and numbering"
|| (GetWindowName (RealWindow) == wwn381)
;wwn382="Drawing defaults"
|| (GetWindowName (RealWindow) == wwn382)
;wwn383="envelopes and labels"
|| (GetWindowName (RealWindow) == wwn383)
;wwn210="customize"
|| (GetWindowName (RealWindow) == wwn210)
;wwn384="cell height and width"
|| (GetWindowName (RealWindow) == wwn384)) then
Say(wmsg385, ot_help) ;"use insert t for current tab with focus"
Say(wmsg386, ot_help) ;"Tab thru the Controls to hear the options"
Say(wmsg387, ot_help) ;"use the space bar to check or uncheck the various check boxes"
Say(wmsg388, ot_help) ;"use control down arrow to read the check boxes and other items"
Say(wmsg376, ot_help) ;"Alt H for Help with options or escape to cancel"
Return
EndIf
;wwc296="OpusWwd"
if TheClass == wwc296 then ; main document window
Say(msgMainDocWindow, ot_help) ;"this is the main document window"
Say(wmsg468, ot_help) ; "to toggle the writing mode between Insert and OverWrite ",
Say(wmsg469, ot_help) ; "use control + alt + I "
return
endif ; OpusWwd

;wwn1="new"
If ((WindowName == wwn1) 
;wfs2="template"
&& (findstring (GetCurrentWindow (),wfs2,0,0))) then
PCCursor ()
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg4, ot_help) ;"Template edit box use alt t"
Say(wmsg5, ot_help) ;"summary button use alt s"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg7, ot_help) ;"document radio button use alt d"
Say(wmsg8, ot_help) ;"template radio button use alt e"
Say(wmsg9, ot_help) ;"Press enter to accept the changes or press escape to cancel"
Return
else
PCCursor ()
EndIf

;wwn10="open"
If (WindowName == wwn10) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg11, ot_help) ;"file name edit box with list use alt n"
Say(wmsg12, ot_help) ;"directories list box use alt d"
Say(wmsg13, ot_help) ;"drives combo box use alt v"
Say(wmsg14, ot_help) ;"list file of type combo box use alt t"
Say(wmsg15, ot_help) ;"find file button use alt f"
Say(wmsg16, ot_help) ;"network button use alt e"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg17, ot_help) ;"confirm conversions check box use alt c"
Say(wmsg18, ot_help) ;"Reid only check box use alt r"
Say(wmsg19, ot_help) ;"Remember that if you jump to a check box with a hot key"
Say(wmsg20, ot_help) ;"it will toggle the box automatically"
Say(wmsg9, ot_help) ;"Press enter to accept the changes or press escape to cancel"
Return
EndIf

;wwn21="summary info"
If (WindowName == wwn21) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg22, ot_help) ;"title edit box use alt t"
Say(wmsg23, ot_help) ;"subject edit box use alt s"
Say(wmsg24, ot_help) ;"author edit box use alt eigh"
Say(wmsg25, ot_help) ;"keywords edit box use alt k"
Say(wmsg26, ot_help) ;"comments edit box use alt c"
Say(wmsg27, ot_help) ;"statistics button use alt eye"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg9, ot_help) ;"Press enter to accept the changes or press escape to cancel"

Return
EndIf

;wwn28="search"
If (WindowName == wwn28) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg29, ot_help) ;"saved searches combo box use alt e"
Say(wmsg30, ot_help) ;"file name combo box use alt n"
Say(wmsg31, ot_help) ;"location combo box use alt l"
Say(wmsg32, ot_help) ;"clear button use alt c"
Say(wmsg33, ot_help) ;"advanced search button use alt eigh"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg34, ot_help) ;"rebuild file list check box use alt r"
Say(wmsg35, ot_help) ;"include subdirectories check box use alt b"
Say(wmsg19, ot_help) ;"Remember that if you jump to a check box with a hot key"
Say(wmsg20, ot_help) ;"it will toggle the box automatically"
Say(wmsg9, ot_help) ;"Press enter to accept the changes or press escape to cancel"
Return
EndIf
;wwn36="advanced search"
If (WindowName == wwn36) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg37, ot_help) ;"This is a tabbed dialog box"
Say(wmsg38, ot_help) ;"To find out which tab is open use insert t"
Say(wmsg39, ot_help) ;"to open the location tab use alt l"
Say(wmsg40, ot_help) ;"to open the summary tab use alt s"
Say(wmsg41, ot_help) ;"to open the timestamp tab use alt p"
;wfs42="subdirectories"
If ((FindString (GetCurrentWindow (),wfs42,0,0))
;wfs43="include"
&& (FindString (GetCurrentWindow (),wfs43,0,0))
;wfs44="drives"
&& (FindString (GetCurrentWindow (),wfs44,0,0))
;wfs45="network"
&& (FindString (GetCurrentWindow (),wfs45,0,0))) then
PCCursor ()
Say(wmsg30, ot_help) ;"file name combo box use alt n"
Say(wmsg46, ot_help) ;"add selected button use alt eigh"
Say(wmsg47, ot_help) ;"remove button use alt r"
Say(wmsg48, ot_help) ;"remove all button use alt m"
Say(wmsg49, ot_help) ;"search in list box use alt e"
Say(wmsg50, ot_help) ;"network button use alt w"
Say(wmsg12, ot_help) ;"directories list box use alt d"
Say(wmsg51, ot_help) ;"drives button use alt v"
Say(wmsg35, ot_help) ;"include subdirectories check box use alt b"
else
PCCursor ()
endif
;wfs52="title"
If ((FindString (GetCurrentWindow (),wfs52,0,0)) 
;wfs53="author"
&& (FindString (GetCurrentWindow (),wfs53,0,0)) 
;wfs54="containing"
&& (FindString ( GetCurrentWindow (),wfs54,0,0))) then
PCCursor ()
Say(wmsg22, ot_help) ;"title edit box use alt t"
Say(wmsg24, ot_help) ;"author edit box use alt eigh"
Say(wmsg25, ot_help) ;"keywords edit box use alt k"
Say(wmsg55, ot_help) ;"subject edit box use alt u"
Say(wmsg56, ot_help) ;"options combo box use alt o"
Say(wmsg57, ot_help) ;"match case check box use alt m"
Say(wmsg58, ot_help) ;"Containing text edit box use alt c"
Say(wmsg59, ot_help) ;"use pattern matching check box use alt r"
Say(wmsg60, ot_help) ;"special button use alt e"
else
PCCursor ()
endif
;wfs61="created"
If ((FindString (GetCurrentWindow (),wfs61,0,0))
;wfs62="saved"
&&  (FindString (GetCurrentWindow (),wfs62,0,0))
;wfs63="from"
&& (FindString (GetCurrentWindow (),wfs63,0,0))) then
PCCursor ()
Say(wmsg64, ot_help) ;"last saved from edit box use alt f"
Say(wmsg65, ot_help) ;"last saved to edit box use alt t"
Say(wmsg66, ot_help) ;"last saved by edit box use alt b"
Say(wmsg67, ot_help) ;"created from edit box use alt r"
Say(wmsg68, ot_help) ;"created to edit box use alt o"
Say(wmsg69, ot_help) ;"created by edit box use alt y"
else
PCCursor ()
endif
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg19, ot_help) ;"Remember that if you jump to a check box with a hot key"
Say(wmsg20, ot_help) ;"it will toggle the box automatically"
Say(wmsg9, ot_help) ;"Press enter to accept the changes or press escape to cancel"
Return
EndIf
;wwn70="Connect Network Drive"
If (WindowName == wwn70) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg71, ot_help) ;"Drive list box use alt d"
Say(wmsg72, ot_help) ;"Path list box use alt p"
Say(wmsg73, ot_help) ;"Reconnect at startup check box use alt t"
Say(wmsg74, ot_help) ;"Always browse use alt eigh"
Say(wmsg75, ot_help) ;"Show shared directories on list box use alt s"
Say(wmsg76, ot_help) ;"Show shared directories list box use alt r"
Say(wmsg77, ot_help) ;"Help button use alt h"
Say(wmsg19, ot_help) ;"Remember that if you jump to a check box with a hot key"
Say(wmsg20, ot_help) ;"it will toggle the box automatically"
Say(wmsg9, ot_help) ;"Press enter to accept the changes or press escape to cancel"
Return
EndIf
;wwn78="Templates and Add-ins"
If (WindowName == wwn78) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg79, ot_help) ;"document template edit box use alt t"
Say(wmsg80, ot_help) ;"Attach button use alt eigh"
Say(wmsg81, ot_help) ;"Automatically update document styles check box use alt u"
Say(wmsg82, ot_help) ;"Global templates and add-ins list box use alt g"
Say(wmsg83, ot_help) ;"add button use alt d"
Say(wmsg84, ot_help) ;"organizer button use alt o"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg19, ot_help) ;"Remember that if you jump to a check box with a hot key"
Say(wmsg20, ot_help) ;"it will toggle the box automatically"
Say(wmsg9, ot_help) ;"Press enter to accept the changes or press escape to cancel"
Return
EndIf

;wwn85="Attach template"
If ((WindowName == wwn85) 
;wwn86="Add template"
|| (WindowName == wwn86)) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg87, ot_help) ;"filename edit box with list use alt n"
Say(wmsg12, ot_help) ;"directories list box use alt d"
Say(wmsg13, ot_help) ;"drives combo box use alt v"
Say(wmsg88, ot_help) ;"list files of type combo box use alt t"
Say(wmsg89, ot_help) ;"fine file button use alt f"
Say(wmsg16, ot_help) ;"network button use alt e"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg9, ot_help) ;"Press enter to accept the changes or press escape to cancel"
Return
EndIf
;wwn90="organizer"
If (WindowName == wwn90) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg37, ot_help) ;"This is a tabbed dialog box"
Say(wmsg91, ot_help) ;"To find out which tab is open use alt t"
Say(wmsg92, ot_help) ;"to open the styles tab use alt s"
Say(wmsg93, ot_help) ;"to open the auto text tab use alt eigh"
Say(wmsg94, ot_help) ;"to open the tool bars tab use alt t"
Say(wmsg95, ot_help) ;"to open the macros tab use alt m"
Say(wmsg96, ot_help) ;"source list box use alt eye"
Say(wmsg97, ot_help) ;"available source combo box use alt v"
Say(wmsg98, ot_help) ;"close source file button use alt f"
Say(wmsg99, ot_help) ;"copy selected button use alt c"
Say(wmsg100, ot_help) ;"Delete selected button use alt d"
Say(wmsg101, ot_help) ;"rename selected button use alt r"
Say(wmsg102, ot_help) ;"destination list box use alt o"
Say(wmsg103, ot_help) ;"available destination comb box alt b"
Say(wmsg104, ot_help) ;"close destination file button use alt e"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg9, ot_help) ;"Press enter to accept the changes or press escape to cancel"
Return
EndIf
;wwn105="rename"
If (WindowName == wwn105) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg106, ot_help) ;"new name list box use alt n"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg9, ot_help) ;"Press enter to accept the changes or press escape to cancel"
Return
EndIf
;wwn107="page setup"
If (WindowName == wwn107) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
;wfs108="top:"
if (FindString (GetCurrentWindow(),wfs108,0,0)) then
PCCursor ()
Say(wmsg109, ot_help) ;"to read static text by an edit box route jaws to pc and sayline"
Say(wmsg110, ot_help) ;"top margin combo box use alt t"
Say(wmsg111, ot_help) ;"bottom margin combo box use alt b"
Say(wmsg112, ot_help) ;"left margin combo box use alt f"
Say(wmsg113, ot_help) ;"right margin combo box use alt  g"
Say(wmsg114, ot_help) ;"gutter combo box use alt u"
Say(wmsg115, ot_help) ;"header combo box use alt e"
Say(wmsg116, ot_help) ;"footer combo box use alt r"
Say(wmsg117, ot_help) ;"Mirror margins check box use alt eye"
else
PCCursor ()
endif
;wfs118="orientation"
if (FindString (GetCurrentWindow(),wfs118,0,0)) then
PCCursor ()
Say(wmsg119, ot_help) ;"paper size combo box use alt r"
Say(wmsg120, ot_help) ;"paper width combo box use alt w"
Say(wmsg121, ot_help) ;"paper height combo box use alt e"
Say(wmsg122, ot_help) ;"protrait orientation radio button use alt eye"
Say(wmsg123, ot_help) ;"landscape orientation radio button use alt c"
else
PCCursor ()
endif
;wfs124="First"
if (FindString (GetCurrentWindow(),wfs124,0,0)) then
PCCursor ()
Say(wmsg125, ot_help) ;"first page list box use alt f"
Say(wmsg126, ot_help) ;"other pages list box use alt o"
else
PCCursor ()
endif
;wfs127="Section"
if (FindString (GetCurrentWindow(),wfs127,0,0)) then
PCCursor ()
Say(wmsg128, ot_help) ;"section start combo box use alt r"
Say(wmsg129, ot_help) ;"different odd and even for headers and footers check box use alt o"
say(wmsg130, ot_help) ;"different first page for headers and footers check box use alt f"
Say(wmsg131, ot_help) ;"Vertical allignment combo use alt v"
Say(wmsg132, ot_help) ;"line numbers button use alt n"
else
PCCursor ()
endif
Say(wmsg133, ot_help) ;"apply to combo box use alt eigh"
Say(wmsg134, ot_help) ;"default button use alt d"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg19, ot_help) ;"Remember that if you jump to a check box with a hot key"
Say(wmsg20, ot_help) ;"it will toggle the box automatically"
return
endif
;wwn135="line numbers"
If (WindowName == wwn135) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg136, ot_help) ;"add line number check box use alt l"
Say(wmsg137, ot_help) ;"start at combo box use alt a"
Say(wmsg138, ot_help) ;"from text combo box use alt t"
Say(wmsg139, ot_help) ;"count by combo box use alt b"
Say(wmsg140, ot_help) ;"restart numbering on each page radio button use alt p"
Say(wmsg141, ot_help) ;"restart numbering on each section radio button use alt s"
Say(wmsg142, ot_help) ;"continuous numbering radio button use alt c"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg19, ot_help) ;"Remember that if you jump to a check box with a hot key"
Say(wmsg20, ot_help) ;"it will toggle the box automatically"
return
endif

;wwn143="microsoft word"
If ((WindowName == wwn143)
;wfs144="setup"
&& (findstring (GetCurrentWindow (),wfs144,0,0))) then
PCCursor ()
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg145, ot_help) ;"yes button use alt y"
Say(wmsg146, ot_help) ;"no button use alt n"
Say(wmsg6, ot_help) ;"help button use alt h"
return
else
PCCursor ()
endif

;wwn147="Print Setup"
If (GetWindowName(GetRealWindow (GetFocus())) == wwn147) then
PCCursor ()
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg148, ot_help) ;"printers list box use alt p"
Say(wmsg149, ot_help) ;"set as default printer use alt d"
Say(wmsg150, ot_help) ;"options dialog box use alt o"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg151, ot_help) ;"network dialog box use alt e"
return
endif
;wwn152="Print"
If (GetWindowName(GetRealWindow (GetFocus())) == wwn152) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg153, ot_help) ;"print what combo box use alt p"
Say(wmsg154, ot_help) ;"copies combo box use alt c"
Say(wmsg155, ot_help) ;"set page range to all radio button use alt eigh"
Say(wmsg156, ot_help) ;"Set page range to current page radio button use alt e"
Say(wmsg157, ot_help) ;"Set page range to selected text radio button use alt n"
Say(wmsg158, ot_help) ;"Set page range to specified pages edit box use alt g"
Say(wmsg159, ot_help) ;"print combo box use alt r"
Say(wmsg150, ot_help) ;"options dialog box use alt o"
Say(wmsg160, ot_help) ;"printer dialog box use alt t"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg161, ot_help) ;"print to file check box use alt l"
Say(wmsg162, ot_help) ;"coellate copies check box use alt eye"
Say(wmsg19, ot_help) ;"Remember that if you jump to a check box with a hot key"
Say(wmsg20, ot_help) ;"it will toggle the box automatically"
return
endif
;wwn163="paste special"
If (WindowName == wwn163) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg164, ot_help) ;"Paste radio button use alt p"
Say(wmsg165, ot_help) ;"Paste link radio button use alt l"
Say(wmsg166, ot_help) ;"Format list box use alt eigh"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg9, ot_help) ;"Press enter to accept the changes or press escape to cancel"
Return
EndIf
;wwn167="Find"
If (WindowName == wwn167) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg168, ot_help) ;"Find what combo box use alt n"
Say(wmsg169, ot_help) ;"Search direction list box use alt s"
Say(wmsg170, ot_help) ;"Match Case check box use alt c"
Say(wmsg171, ot_help) ;"Find Whole words only check box use alt w"
Say(wmsg172, ot_help) ;"Use pattern matching check box use alt m"
Say(wmsg173, ot_help) ;"Sounds like check box use alt l"
Say(wmsg174, ot_help) ;"find format list box use alt o"
Say(wmsg175, ot_help) ;"find special list box use alt e"
Say(wmsg176, ot_help) ;"Find next button use alt f"
Say(wmsg177, ot_help) ;"replace dialog box use alt r"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg19, ot_help) ;"Remember that if you jump to a check box with a hot key"
Say(wmsg20, ot_help) ;"it will toggle the box automatically"
Say(wmsg178, ot_help) ;"Press enter to accept the find string or press escape to cancel"
Return
EndIf

;wwn179="replace"
If (WindowName == wwn179) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg168, ot_help) ;"Find what combo box use alt n"
Say(wmsg180, ot_help) ;"Replace with combo box use alt p"
Say(wmsg169, ot_help) ;"Search direction list box use alt s"
Say(wmsg170, ot_help) ;"Match Case check box use alt c"
Say(wmsg171, ot_help) ;"Find Whole words only check box use alt w"
Say(wmsg172, ot_help) ;"Use pattern matching check box use alt m"
Say(wmsg173, ot_help) ;"Sounds like check box use alt l"
Say(wmsg174, ot_help) ;"find format list box use alt o"
Say(wmsg175, ot_help) ;"find special list box use alt e"
Say(wmsg176, ot_help) ;"Find next button use alt f"
Say(wmsg181, ot_help) ;"Replace button use alt r"
Say(wmsg182, ot_help) ;"replace all button use alt eigh"
Say(wmsg77, ot_help) ;"Help button use alt h"
Say(wmsg19, ot_help) ;"Remember that if you jump to a check box with a hot key"
Say(wmsg20, ot_help) ;"it will toggle the box automatically"
Say(wmsg183, ot_help) ;"Press enter or alt r to initiate replacement or press escape to cancel"
Return
EndIf

;wwn184="Go To"
If (WindowName == wwn184) then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg185, ot_help) ;"go to what list box use alt W"
Say(wmsg186, ot_help) ;"Enter name or number edit box use alt e"
Say(wmsg187, ot_help) ;"Next button use alt tee"
Say(wmsg188, ot_help) ;"Previous button use alt p"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg189, ot_help) ;"Press enter to accept the go to or press escape to cancel"
Return
EndIf
;wwn190="Bookmark"
If (WindowName == wwn190)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg191, ot_help) ;"Bookmark combo box use alt b"
Say(wmsg192, ot_help) ;"Add button use alt eigh"
Say(wmsg193, ot_help) ;"Delete button use alt D"
Say(wmsg194, ot_help) ;"Go to button use alt g"
Say(wmsg195, ot_help) ;"Sort by name radio button use alt n"
Say(wmsg196, ot_help) ;"Sort by location radio button use alt l"
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg9, ot_help) ;"Press enter to accept the changes or press escape to cancel"
Return
EndIf
;wwn197="new toolbar"
If (WindowName == wwn197)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg198, ot_help) ;"tool bar name edit box use alt t"
Say(wmsg199, ot_help) ;"make tool bar available to combo box use alt m"
Say(wmsg6, ot_help) ;"help button use alt h"
return
endif
;wwn200="Toolbars"
If (WindowName == wwn200)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg201, ot_help) ;"Toolbars list of check boxes use alt t"
Say(wmsg202, ot_help) ;"color buttons check box use alt o"
Say(wmsg203, ot_help) ;"Large buttons check box use alt l"
Say(wmsg204, ot_help) ;"show tooltips check box use alt s"
Say(wmsg205, ot_help) ;"new dialog box use alt n"
Say(wmsg206, ot_help) ;"reset dialog box use alt r"
Say(wmsg207, ot_help) ;"customize dialog box use alt c"
Say(wmsg6, ot_help) ;"help button use alt h"
return
endif
;wwn208="reset toolbar"
If (WindowName == wwn208)  then
Say(wmsg209, ot_help) ;"Use the Tab key or use alt h for additional windows help"
return
endif
;wwn210="customize"
If (WindowName == wwn210)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg37, ot_help) ;"This is a tabbed dialog box"
Say(wmsg211, ot_help) ;"To find the current tab use insert t"
;wfs212="buttons"
If (findstring (GetCurrentWindow(),wfs212,0,0)) then
PCCursor ()
Say(wmsg213, ot_help) ;"tab equals toolbars"
Say(wmsg214, ot_help) ;"categories list box use alt c"
endif
;wfs215="menu"
If (findstring (GetCurrentWindow(),wfs215,0,0)) then
PCCursor ()
Say(wmsg216, ot_help) ;"tab equals menus"
Say(wmsg214, ot_help) ;"categories list box use alt c"
Say(wmsg217, ot_help) ;"commands list box use alt o"
Say(wmsg218, ot_help) ;"change what menu combo box use alt u"
Say(wmsg219, ot_help) ;"position on menu combo box use alt p"
Say(wmsg220, ot_help) ;"name on manu edit box use alt n"
Say(wmsg221, ot_help) ;"add button use alt a"
Say(wmsg222, ot_help) ;"menu bar dialog box use alt b"
endif
;wfs223="shortcut"
If (findstring (GetCurrentWindow(),wfs223,0,0)) then
PCCursor ()
Say(wmsg224, ot_help) ;"tab equals keyboard"
Say(wmsg214, ot_help) ;"categories list box use alt c"
Say(wmsg217, ot_help) ;"commands list box use alt o"
Say(wmsg225, ot_help) ;"press new shortcut key edit box use alt n"
Say(wmsg226, ot_help) ;"current keys list box use alt u"
else
PCCursor ()
endif
Say(wmsg6, ot_help) ;"help button use alt h"
Say(wmsg227, ot_help) ;"save changes in combo box use alt v"
return
endif

;wwn228="menu bar"
If (WindowName == wwn228)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg229, ot_help) ;"Name on menu bar edit box use alt n"
Say(wmsg230, ot_help) ;"position on Menu bar list box use alt p"
Say(wmsg6, ot_help) ;"help button use alt h"
return
endif
;wwn231="zoom"
If (WindowName == wwn231)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg232, ot_help) ;"200 percent radio button use alt 2"
Say(wmsg233, ot_help) ;"100 percent radio button use alt 1"
Say(wmsg234, ot_help) ;"75 percent radio button use alt 7"
Say(wmsg235, ot_help) ;"page width radio button use alt p"
Say(wmsg236, ot_help) ;"percent combo box use alt e"
Say(wmsg6, ot_help) ;"help button use alt h"
return
endif
;wwn237="break"
If (WindowName == wwn237)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg238, ot_help) ;"insert page break radio button use alt p"
Say(wmsg239, ot_help) ;"insert column break radio button use alt c"
Say(wmsg240, ot_help) ;"section break on next page radio button use alt n"
Say(wmsg241, ot_help) ;"section break on even pages radio button use alt e"
Say(wmsg242, ot_help) ;"section break on odd pages radio button use alt o"
Say(wmsg243, ot_help) ;"continuous radio button use alt t"
Say(wmsg6, ot_help) ;"help button use alt h"
return
endif
;wwn244="page numbers"
If (WindowName == wwn244)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg245, ot_help) ;"position combo box use alt p"
Say(wmsg246, ot_help) ;"alignment combo box use alt eigh"
Say(wmsg247, ot_help) ;"show number on first page check box use alt s"
Say(wmsg248, ot_help) ;"format dialog box use alt f"
Say(wmsg6, ot_help) ;"help button use alt h"
return
endif
;wwn249="page number format"
If (WindowName == wwn249)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg250, ot_help) ;"number format combo box use alt f"
Say(wmsg251, ot_help) ;"include chapter number check box use alt n"
Say(wmsg252, ot_help) ;"chapter starts with style combo box use alt p"
Say(wmsg253, ot_help) ;"use separator combo box use alt e"
Say(wmsg254, ot_help) ;"page numbering continue from previous section radio button use alt c"
Say(wmsg255, ot_help) ;"page numbering start at combo box use alt eigh"
Say(wmsg6, ot_help) ;"help button use alt h"
return
endif
;wwn256="date and time"
If (WindowName == wwn256)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg257, ot_help) ;"available formats check box use alt eigh"
Say(wmsg258, ot_help) ;"insert as field check box use alt eye"
Say(wmsg6, ot_help) ;"help button use alt h"
return
endif
;wwn259="field"
If (WindowName == wwn259)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg260, ot_help) ;"Categories list box use alt c"
Say(wmsg261, ot_help) ;"field names list box use alt n"
Say(wmsg262, ot_help) ;"field codes edit box use alt f"
Say(wmsg263, ot_help) ;"Preserve formatting during updates check box use alt p"
Say(wmsg150, ot_help) ;"options dialog box use alt o"
Say(wmsg6, ot_help) ;"help button use alt h"
return
endif
;wwn264="symbol"
If (WindowName == wwn264)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg37, ot_help) ;"This is a tabbed dialog box"
Say(wmsg265, ot_help) ;"To speak the current tab use insert t"
Say(wmsg266, ot_help) ;"To open the symbols tab use alt s"
Say(wmsg267, ot_help) ;"to open the special characters tab use alt p"
;wfs268="font"
if (findstring (GetCurrentWindow (),wfs268,0,0)) then
PCCursor ()
Say(wmsg269, ot_help) ;"font combo box use alt f"
endif
;wfs270="character:"
if (findstring (GetCurrentWindow (),wfs270,0,0)) then
PCCursor ()
Say(wmsg271, ot_help) ;"character and shortcut key list box use alt c"
else
PCCursor ()
endif
Say(wmsg272, ot_help) ;"insert button use alt eye"
Say(wmsg273, ot_help) ;"shortcut key dialog box use alt k"
Say(wmsg6, ot_help) ;"help button use alt h"
return
endif
;wwn274="form fieldl"
If (WindowName == wwn274)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg275, ot_help) ;"text radio button use alt t"
Say(wmsg276, ot_help) ;"check box radio button use alt c"
Say(wmsg277, ot_help) ;"drop-down radio button use alt d"
Say(wmsg278, ot_help) ;"show toolbar button use alt s"
Say(wmsg150, ot_help) ;"options dialog box use alt o"
Say(wmsg6, ot_help) ;"help button use alt h"
return
endif
;wwn279="text form field options"
If (WindowName == wwn279)  then
Say(wmsg3, ot_help) ;"Use the Tab key or the following Windows hot keys"
Say(wmsg280, ot_help) ;"type combo box use alt p"
Say(wmsg281, ot_help) ;"default text edit box use alt e"
Say(wmsg282, ot_help) ;"maximum length combo box use alt m"
Say(wmsg283, ot_help) ;"text format combo box use alt f"
Say(wmsg284, ot_help) ;"run macro on entry combo box use alt y"
Say(wmsg285, ot_help) ;"run macro on exit use alt x"
Say(wmsg286, ot_help) ;"field settings bookmark use alt b"
Say(wmsg287, ot_help) ;"fill-in enabled check box use alt n"
Say(wmsg288, ot_help) ;"add help text diolog box use alt t"
Say(wmsg6, ot_help) ;"help button use alt h"
return
endif
Say(wmsg289, ot_help) ;"Use the tab key to move between the fields"
Say(wmsg290, ot_help) ;"For additional windows help"
Say(wmsg291, ot_help) ;"type alt plus h or try the insert plus f 1 for screen sensitive help"
PerformScript ScreenSensitiveHelp ()
EndFunction

Void Function ToggleWritingMode95 ()
var
	handle WinHandle
let WinHandle = GetAppMainWindow (GetFocus ())
let WinHandle = GetFirstChild (WinHandle)
; wwc393 = "OpusStat",
while (WinHandle && (GetWindowClass (WinHandle) != wwc393))
	let WinHandle = GetNextWindow (WinHandle)
EndWhile
{insert}
if (GetWindowClass (WinHandle) == wwc393) then
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (WinHandle)
; wfs464 = "OVR" (OverWrite)
	if FindString (WinHandle, wfs464, s_bottom, s_restricted) then
		Say(wmsg465, ot_message) ; "OverWrite mode"
	else
		Say(wmsg466, ot_message) ; "Insert mode"
	EndIf
else
	Say(wmsg467, ot_message) ; "Status Line not found"
EndIf
EndFunction

Script SayNextLine ()
PerformScript SayNextLine() 
EndScript

Script SayPriorLine ()
PerformScript SayPriorLine()
EndScript

Script SayNextCharacter ()
PerformScript SayNextCharacter()
EndScript

Script SayPriorCharacter ()
PerformScript SayPriorCharacter()
EndScript


Script tabKey ()
var
int Typing_echo

Let Typing_Echo=GetDefaultJCFOption (opt_typing_Echo)
; this function is here to avoid the unknown function call msg but the function is not required by word 95.
If (Typing_Echo != 0) Then
	say(wmsg540,ot_message)
endIf
{tab}
EndScript

Script shiftTabKey ()
var
int Typing_echo
; this function is here to avoid the unknown function call msg but the function is not required by word 95.
Let Typing_Echo=GetDefaultJCFOption (opt_typing_Echo)

If (Typing_Echo != 0) Then
	say(wmsg541,ot_message)
endIf
{shift+tab}
EndScript

Function Unknown (string TheName, int IsScript)
; ignore all word 2000/97 scripts not applicable to word 95
EndFunction